local function ScoreResults(pn)
	local CurStats = STATSMAN:GetCurStageStats():GetPlayerStageStats(pn)
	--Perfects (W1+W2+Holdticks)
	local HitHoldTicks = CurStats:GetTapNoteScores('TapNoteScore_CheckpointHit')
	local TnsW1s = CurStats:GetTapNoteScores('TapNoteScore_W1')
	local TnsW2s = CurStats:GetTapNoteScores('TapNoteScore_W2')
	local Perfects = HitHoldTicks+TnsW1s+TnsW2s
	--Misses (Miss+Holdtickmisses)
	local MissHoldTicks = CurStats:GetTapNoteScores('TapNoteScore_CheckpointMiss')
	local TnsMiss = CurStats:GetTapNoteScores('TapNoteScore_Miss')
	local Misses = MissHoldTicks+TnsMiss
	
	local iScores = {
		Perfects,
		CurStats:GetTapNoteScores('TapNoteScore_W3'),	--greats
		CurStats:GetTapNoteScores('TapNoteScore_W4'),	--goods
		CurStats:GetTapNoteScores('TapNoteScore_W5'),	--bads
		Misses,
		CurStats:MaxCombo(),
	}
	local t = Def.ActorFrame {
		InitCommand=cmd(player,pn)
	}
	for i=1,#iScores do
		t[#t+1] = LoadFont("score")..{
			Text=string.format("%03i", iScores[i]);
			InitCommand=function(self)
				(cmd(shadowlength,0;zoom,1.1;maxwidth,150))(self);
				self:y((i-1)*46);
				self:horizalign(pn == PLAYER_1 and left or right);
			end;
			OnCommand=function(self)
				if pn == PLAYER_1 then
					self:cropright(1);
				else
					self:cropleft(1);
				end;
				self:sleep((0.3*(i-1))+1);
				self:linear(0.4);
				if pn == PLAYER_1 then
					self:cropright(-1);
				else
					self:cropleft(-1);
				end;
				self:sleep(5.3-((i-1)*0.3));
				self:decelerate(0.4);
				self:addx(pn == PLAYER_1 and -200 or 200);
			end;
		}
		--no me gusta como se v...
		--el que me ayude se lo voy a agradecer :D
		--[[t[#t+1] = Def.RollingNumbers {
			Format="%03.0f";
			ApproachSeconds=0.4;
			File=THEME:GetPathF("","score");
			InitCommand=function(self)
				(cmd(shadowlength,0;zoom,1.1;maxwidth,150))(self);
				self:y((i-1)*46);
				self:horizalign(pn == PLAYER_1 and left or right);
			end;
			OnCommand=function(self)
				self:sleep((0.3*(i-1))+1);
				self:queuecommand("Score");
				self:sleep(5.7-((i-1)*0.3));
				self:decelerate(0.4);
				self:addx(pn == PLAYER_1 and -200 or 200);
			end;
			ScoreCommand=function(self)
				self:targetnumber(iScores[i]);
			end;
		}]]
	end
	t[#t+1] = LoadFont("score")..{
		Text=string.format("%07i", CurStats:GetScore());
		InitCommand=function(self)
			(cmd(shadowlength,0;zoom,1.1;maxwidth,150))(self);
			self:y(46*#iScores);
			self:horizalign(pn == PLAYER_1 and left or right);
		end;
		OnCommand=function(self)
			if pn == PLAYER_1 then
				self:cropright(1);
			else
				self:cropleft(1);
			end;
			self:sleep(2.8);
			self:linear(0.964);
			if pn == PLAYER_1 then
				self:cropright(-1);
			else
				self:cropleft(-1);
			end;
			self:sleep(2.9335);	--0.289
			self:decelerate(0.4);
			self:addx(pn == PLAYER_1 and -200 or 200);
		end;
	}
	if getenv("PercentResults") then
		t[#t+1] = Def.RollingNumbers {
			Format="%.2f%%";
			ApproachSeconds=2.3;
			File=THEME:GetPathF("","ArialOutline");
			InitCommand=function(self)
				(cmd(shadowlength,0;zoom,0))(self);
				self:y(-46);
				self:horizalign(pn == PLAYER_1 and left or right);
			end;
			OnCommand=function(self)
				self:sleep(0.2);
				self:zoom(1);
				self:sleep(0.8);
				self:queuecommand("Score");
				self:sleep(5.5);
				self:zoom(0);
			end;
			ScoreCommand=function(self)
				self:targetnumber(CurStats:GetPercentDancePoints()*100);
			end;
		}
	end
	return t
end

local function Grade(pn)
	local sGrade = STATSMAN:GetCurStageStats():GetPlayerStageStats(pn):GetGrade()
	local FileGrades = {
		Grade_Tier01 = "_+S";
		Grade_Tier02 = "_S";
		Grade_Tier03 = "_A";
		Grade_Tier04 = "_B";
		Grade_Tier05 = "_C";
		Grade_Tier06 = "_D";
		Grade_Tier07 = "_F";
		Grade_Failed = "_F";
	}
	local fGrade = FileGrades[sGrade]
	if not fGrade then
		fGrade = "_F"
	end
	return LoadActor( fGrade..".png" )..{
		InitCommand=cmd(player,pn);
		OnCommand=function(self)
			self:addx(pn == PLAYER_1 and 46 or -46);
			(cmd(addy,-46;zoom,1.5;diffusealpha,0;sleep,3.5;linear,0.2;zoom,1;addy,46;diffusealpha,1))(self);
			self:addx(pn == PLAYER_1 and -46 or 46);
			(cmd(sleep,3;decelerate,0.4))(self);
			self:addx(pn == PLAYER_1 and -200 or 200)
		end;
	}
end

local function GradeSound()
	local SoundGrades = {"A","A","A","B","C","D","F","F"}
	--duh T_T
	local rnk = SoundGrades[STATSMAN:GetBestGrade()+1]
	if not rnk then
		rnk = "F"
	end
	return LoadActor("RANK_"..rnk)..{
		OnCommand=function(self)
			self:sleep(3.5);
			self:queuecommand("PlaySound");
		end;
		PlaySoundCommand=function(self)
			self:play();
		end;
	}
end

local x = Def.ActorFrame {}

for player in ivalues(PlayerNumber) do
	x[#x+1] = ScoreResults(player)..{
		InitCommand=function(self)
			(cmd(y,150))(self);
			self:x(player == PLAYER_1 and SCREEN_LEFT+6 or SCREEN_RIGHT-6);
		end;
	}
	x[#x+1] = Grade(player)..{
		InitCommand=function(self)
			(cmd(y,277))(self);
			self:x(player == PLAYER_1 and SCREEN_LEFT+86 or SCREEN_RIGHT-86);
		end;
	}
end
x[#x+1] = GradeSound()

return x